# G20_v2 — Boundary Masks (+2/+3)

This repo snapshot contains the **passing** G20_v2 simulation (azimuth-stable geometry). 
Control is **present-act, deterministic (1/r per shell)** and uses only the Python stdlib.

## How to run (reproduce)

```bash
# from repo root
python engine_g20_boundary_masks_v2.py   --manifest config/manifest_g20_v2.json   --outdir runs/$(date -u +%Y-%m-%dT%H-%M-%SZ)/
```

Or use the convenience script:

```bash
./scripts/run.sh
```

This will create a new timestamped folder under `runs/` with `outputs/metrics`, `outputs/audits`, and `outputs/run_info/`.
The acceptance result will also be printed to stdout.

## Recorded passing run

- Timestamp: **2025-11-06T19-07-18Z**
- One-line result:
```
G20_v2 PASS=True slope_B=1.0119 slope_M=1.0119 Δslope=0.0000 cv_B=0.0081 cv_M=0.0064 Δcv=0.0017 amp_ratio=0.500 pred=0.500 az_B=0.0186 az_M=0.0197
```

### Acceptance gates (enforced by the engine)
- Per panel: |slope−1| ≤ 0.15, R² ≥ 0.90, CV ≤ 0.10, azimuth flatness ≤ 0.03
- Cross-panel: |Δslope| ≤ 0.05, |ΔCV| ≤ 0.02
- Amplitude scaling: |measured ratio − predicted geometry| ≤ 0.03

## Files

- `engine_g20_boundary_masks_v2.py` — engine (stdlib only; no external deps)
- `config/manifest_g20_v2.json` — passing manifest
- `runs/2025-11-06T19-07-18Z/` — exact passing run (outputs + logs + in-run config copy)
- `scripts/run.sh` — convenience runner (Linux/macOS)

## Requirements
- Python 3.9+ (stdlib only)
